% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{textCloud}
\alias{textCloud}
\title{Wordcloud Plot}
\usage{
textCloud(
  text,
  lang = "english",
  exclude = NULL,
  seed = 0,
  keep_spaces = FALSE,
  min = 2,
  pal = NA,
  print = TRUE
)
}
\arguments{
\item{text}{Character vector}

\item{lang}{Character. Language in text (used for stop words)}

\item{exclude}{Character vector. Which word do you wish to exclude?}

\item{seed}{Numeric. Seed for re-producible plots}

\item{keep_spaces}{Boolean. If you wish to keep spaces in each line
to keep unique compount words, separated with spaces, set to TRUE.
For example, 'LA ALAMEDA' will be set as 'LA_ALAMEDA' and treated as
a single word.}

\item{min}{Integer. Words with less frequency will not be plotted}

\item{pal}{Character vector. Which colours do you wish to use}

\item{print}{Boolean. Plot results as textcloud?}
}
\value{
wordcloud plot object
}
\description{
Study the distribution of a target variable vs another variable. This
function is quite similar to the funModeling's corrplot function.
}
\seealso{
Other Text Mining: 
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Text Mining}
