% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_file}
\alias{stocks_file}
\alias{daily_stocks}
\alias{daily_portfolio}
\alias{stocks_obj}
\alias{stocks_report}
\title{Build a Personal Investing Portfolio Report}
\usage{
stocks_file(
  file = NA,
  creds = NA,
  auto = TRUE,
  sheets = c("Portafolio", "Fondos", "Transacciones"),
  keep_old = TRUE,
  cache = TRUE,
  quiet = FALSE,
  ...
)

daily_stocks(hist, trans, tickers = NA, window = "MAX", ...)

daily_portfolio(hist, trans, cash, cash_fix = 0, window = "MAX")

stocks_obj(
  data = stocks_file(),
  cash_fix = 0,
  tax = 30,
  sectors = FALSE,
  parg = FALSE,
  window = c("1M", "YTD", "1Y", "MAX"),
  cache = TRUE,
  quiet = FALSE
)

stocks_report(
  data = NA,
  keep_old = TRUE,
  dir = NA,
  mail = FALSE,
  attachment = TRUE,
  to = "laresbernardo@gmail.com",
  sectors = FALSE,
  keep = FALSE,
  creds = NA,
  cache = TRUE
)
}
\arguments{
\item{file}{Character. Import an Excel file, local or from URL.}

\item{creds}{Character. Credential's user (see \code{get_creds()}) for
sending mail and Dropbox interaction.}

\item{auto}{Boolean. Automatically use my local personal file? You might want
to set in into your .Renviron \code{LARES_PORTFOLIO=~/dir/to/your/file.xlsx} so you
can leave all other parameters as \code{NA} and use it every time.}

\item{sheets}{Character Vector. Names of each sheet containing Portfolio summary,
Cash, and Transactions information. Please, keep the order of these tabs.}

\item{keep_old}{Boolean. Include sold tickers even though not currently in portfolio?}

\item{cache}{Boolean. Use daily cache if available?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}

\item{...}{Additional parameters.}

\item{hist}{Dataframe. Result from \code{stocks_hist()}}

\item{trans}{Dataframe. Result from \code{stocks_file()$transactions}}

\item{tickers}{Dataframe. Result from \code{stocks_file()$portfolio}}

\item{window}{Character. Choose any of: "1W", "1M", "6M", "1Y", "YTD", "5Y", "MAX"}

\item{cash}{Dataframe. Result from \code{stocks_file()$cash}}

\item{cash_fix}{Numeric. If, for some reason, you need to fix your
cash amount for all reports, set the amount here}

\item{data}{Character. \code{stocks_obj()} output. If NA, automatic
parameters and \code{stocks_file()} defaults will be used.}

\item{tax}{Numeric. How much [0-99] of your dividends are gone with taxes?}

\item{sectors}{Boolean. Return sectors segmentation for ETFs?}

\item{parg}{Boolean. Personal argument. Used to personalize stuff, in this
case, taxes changed from A to B in given date (hard-coded)}

\item{dir}{Character. Directory for HTML report output. If set to NA,
current working directory will be used. If mail sent, file will be erased}

\item{mail}{Boolean. Do you want to send an email with the report attached?
If not, an HTML file will be created in dir}

\item{attachment}{Boolean. Create and add report as attachment if
\code{mail=TRUE}? If not, no report will be rendered and only tabulated
summaries will be included on email's body.}

\item{to}{Character. Email to send the report to}

\item{keep}{Boolean. Keep HTML file when sent by email?}
}
\value{
List with portfolio, transactions, and cash data.frames.

data.frame. Processed at date and symbol level.

data.frame. Processed at date and portfolio level.

List. Aggregated results and plots.

Invisible list. Aggregated results and plots.
}
\description{
\code{stocks_file()} lets the user download his personal Excel with his
Portfolio's data, locally or from Dropbox.

\code{daily_stocks()} creates a dataframe with all relevant metrics and values,
for each ticker or symbol, for every day since inception.

\code{daily_portfolio()} creates a data.frame with all relevant
metrics and values, for the overall portfolio, for every day
since inception.

\code{stocks_obj()} lets the user create his portfolio's calculations and
plots for further study.

\code{stocks_report()} lets the user create his portfolio's full report with
plots and send it to an email with the HTML report attached
}
\examples{
\dontrun{
# Load lares dummy portfolio XLSX
file <- system.file("inst/docs", "dummyPortfolio.xlsx", package = "lares")
df <- stocks_file(
  file = file,
  sheets = c("Portafolio", "Fondos", "Transacciones"),
  keep_old = FALSE
)
}
\dontrun{
list <- stocks_obj()
stocks_report(list, dir = "~/Desktop")
}
}
\seealso{
Other Investment: 
\code{\link{etf_sector}()},
\code{\link{splot_summary}()},
\code{\link{stocks_quote}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{encrypt_file}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mail_send}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}
}
\concept{Credentials}
\concept{Investment}
