% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_cuts}
\alias{mplot_cuts}
\title{Cuts by quantiles for score plot}
\usage{
mplot_cuts(
  score,
  splits = 10,
  model_name = NA,
  subtitle = NA,
  table = FALSE,
  save = FALSE,
  subdir = NA,
  file_name = "viz_ncuts.png"
)
}
\arguments{
\item{score}{Vector. Predicted value or model's result.}

\item{splits}{Integer. Numer of separations to plot}

\item{model_name}{Character. Model's name}

\item{subtitle}{Character. Subtitle to show in plot}

\item{table}{Boolean. Do you wish to return a table with results?}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\value{
Plot with performance results by cuts.
}
\description{
This function cuts by quantiles any score or prediction.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
head(dfr$class2)

# Data
mplot_cuts(dfr$class2$scores, splits = 5, table = TRUE)

# Plot
mplot_cuts(dfr$class2$scores, model_name = "Titanic Survived Model")
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
