% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setDispersalPathogen}
\alias{setDispersalPathogen}
\title{Set pathogen dispersal}
\usage{
setDispersalPathogen(params, mat_clonal, mat_sex = NULL)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{mat_clonal}{a square matrix giving the probability of pathogen dispersal
(clonal propagules) from any polygon of the landscape to any other polygon.
It can be generated manually, or, alternatively, via \code{\link{loadDispersalPathogen}}.
The size of the matrix must match the number of polygons in the landscape, and lines of
the matrix may sum to 1 (reflecting boundaries) or be <1 (absorbing boundaries).}

\item{mat_sex}{a square matrix giving the probability of pathogen dispersal (sexual propagules)
from any polygon of the landscape to any other polygon (default identity matrix) .
It can be generated manually, or, alternatively, via \code{\link{loadDispersalPathogen}}.
The size of the matrix must match the number of polygons in the landscape, and lines of
the matrix may sum to 1 (reflecting boundaries) or be <1 (absorbing boundaries).}
}
\value{
a LandsepiParam object.
}
\description{
Updates a LandsepiParams object with a pathogen dispersal matrix.
Note that landscape parameters must be set before updating setting dispersal.
}
\details{
See tutorial (vignettes) on how to
use your own landscape and compute your own pathogen dispersal kernel.
The dispersal matrix a square matrix whose size is the number of polygons in the landscape
and whose elements are, for each line i and each column i' the probability that propagules
migrate from polygon i to polygon i'.
Lines of the matrix can be normalised to sum to 1 (reflective boundaries);
otherwise propagules dispersing outside the landscape are lost (absorbing boundaries).
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setLandscape(simul_params, loadLandscape(1))
d <- loadDispersalPathogen(1)
simul_params <- setDispersalPathogen(simul_params, d[[1]], d[[2]])
simul_params@DispPathoClonal
}
}
\seealso{
\link{loadDispersalPathogen}
}
