% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_factor_atts.R
\name{get_factor_atts}
\alias{get_factor_atts}
\title{Get Factor Attributes from a Labeled Data Frame}
\usage{
get_factor_atts(data)
}
\arguments{
\item{data}{the labelr labeled data.frame you are checking for factor
variables.}
}
\value{
A list of character vectors, each named according to the convention
"factor." + variable name (e.g.,"factor.Species" for iris$Species). If the
data.frame lacks labelr attributes or lacks factors, an empty list will be
returned.
}
\description{
\code{get_factor_atts} searches a labelr labeled data.frame for factors. If any
are found, a list of character vectors of factor levels is returned, with
each character vector being the set of unique levels for a factor variable,
and with each character vector named according to the convention "factor." +
variable name (e.g.,"factor.Species" for iris$Species). Used internally by
other labelr functions to get information about factors in labeled
data.frames.
}
\examples{
ir2 <- iris
unique(ir2$Species)

ir2 <- add_val_labs(ir2,
  vars = "Species", vals = c(
    "setosa",
    "versicolor",
    "virginica"
  ),
  labs = c("se", "ve", "vi")
)
get_val_labs(ir2)
head(use_val_labs(ir2))
get_factor_atts(iris) # no such info: iris is not labelr labeled
get_factor_atts(ir2) # this one has info: it's labelr labeled
}
