% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_quant_labs.R
\name{all_quant_labs}
\alias{all_quant_labs}
\alias{allq}
\title{Add Quantile-based Value Labels to All Numeric Vars that Meet Specifications}
\usage{
all_quant_labs(data, qtiles = 5, not.vars = NULL, unique.vals.thresh = 10)

allq(data, qtiles = 5, not.vars = NULL, unique.vals.thresh = 10)
}
\arguments{
\item{data}{a data.frame.}

\item{qtiles}{the number of quantile categories to employ (e.g., 4 would
indicate quartiles, 5 would indicate quintiles, 10 for deciles, etc.).}

\item{not.vars}{used to specify any numeric variables that should be exempted
from this operation.}

\item{unique.vals.thresh}{an integer. Numeric variables with fewer than this
many unique variables will be exempted from the operation (i.e., will NOT
receive quantile value labels).}
}
\value{
A data.frame, with new variable value labels added.
}
\description{
Add variable-specific quantile-based value labels to all numeric variables of
a data.frame that meet specified conditions.
}
\details{
Note: \code{allq} is a compact alias for \code{all_quant_labs}: they do the same thing,
and the former is easier to type.

Numerical variables that feature decimals or large numbers of distinct values
are not eligible to receive conventional \code{add_val_labs()}-style value labels.
\code{all_quant_labs} allows one to label such variables based on quantile
thresholds.
}
\examples{
# mtcars demo
df <- mtcars
get_val_labs(df) # none
# add quintile val labs for all numeric vars with >10 unique vals
df <- all_quant_labs(data = df, qtiles = 5, unique.vals.thresh = 10)
get_val_labs(df) # here now
headl(df) # show them; note this is labelr::headl(), not utils::head()
}
