% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vario_plot.R
\name{vario_plot}
\alias{vario_plot}
\title{Create Variogram Plot}
\usage{
vario_plot(
  data,
  factor,
  nlags = NA,
  lags = NA,
  nugget,
  sill,
  range_val,
  a,
  model_name
)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}

\item{factor}{The target factor (FAC) to be used for variogram calculation and fitting.}

\item{nlags}{The number of lag bins for variogram calculation. Default is NA, which will
use Sturges' formula to determine the number of lags.}

\item{lags}{The lag width for variogram calculation. Default is NA, which will calculate
the lag width based on the range of distances.}

\item{nugget}{The nugget effect parameter for the variogram model.}

\item{sill}{The sill parameter for the variogram model.}

\item{range_val}{The range parameter for the variogram model.}

\item{a}{Additional parameter (depends on the variogram model) use NA if not needed.}

\item{model_name}{The name of the model to use for variogram fitting.
Available options include "Sph1", "Exp1", "Gau1", "Mat1", "Pow1", "Quad1", "Card1", "Gam1", "Cau1",
"Sta1", "Ord1", "Tri1", and "Cos1". Use function \code{print_model_names()} for more information.}
}
\value{
A plot displaying the empirical variogram and the fitted variogram based on the specified model.
}
\description{
This function calculates the empirical variogram for a given target factor (FAC)
and plots it along with the fitted variogram based on the specified variogram model.
}
\examples{
data(Klovan_Row80)
# Plot variogram for FAC1
vario_plot(Klovan_Row80, factor = 1, nlags = 10, nugget = 0.01, sill = 2.5,
range_val = 1000, a = NA, model_name = "Sph1")

}
