% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen_contribution.R
\name{eigen_contribution}
\alias{eigen_contribution}
\title{Calculate Eigen Contribution}
\usage{
eigen_contribution(Cov_Mtrx)
}
\arguments{
\item{Cov_Mtrx}{A covariance matrix used to compute the eigenvalues or
A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}
}
\value{
A data frame with columns: "EigenValues", "CumSum", "CumSumPct", "pc.names". Where:
- "EigenValues": The eigenvalues
- "CumSum": The cumulative sum of the eigenvalues
- "CumSumPct": The proportional contribution of each eigenvalue
- "pc.names": The principal component names
}
\description{
This function calculates the sum of all the eigenvalues from a provided covariance matrix or klovan dataset.
Each eigenvalue is divided by the sum of the eigenvalues to determine its proportional contribution.
This yields the percent contribution of each eigenvalue and provides an understanding of the proportion of total variance explained by each eigenvalue.
}
\examples{
data("Klovan_Row80")
your_cov_Mtrx <- covar_mtrx(Klovan_Row80) # example covariance matrix
eigen_contribution(Klovan_Row80) # view the data frame
eigen_contribution(your_cov_Mtrx) # view the data frame
eigen_contribution(covar_mtrx(Klovan_Row80)) # view the data frame

}
