% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_analysis.R
\name{factor_analysis}
\alias{factor_analysis}
\title{Perform Factor Analysis}
\usage{
factor_analysis(data, num_fac = 3)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details}

\item{num_fac}{A numeric value indicating the number of factors to analyze.
It's recommended to use 3, which is also the default value.}
}
\value{
A data frame containing the calculated factors.
}
\description{
This function performs a Factor Analysis on a provided dataset using the "Varimax" orthogonal rotation method.
It also calculates the factor scores for each factor.
}
\examples{
data("Klovan_Row80")
factor_analysis(Klovan_Row80)
factor_analysis(Klovan_Row80, 3)

}
