% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene_test.R
\name{levene_test}
\alias{levene_test}
\title{Levene's test}
\usage{
levene_test(
  data = NULL,
  dv_name = NULL,
  iv_1_name = NULL,
  iv_2_name = NULL,
  round_f = 2,
  round_p = 3,
  output_type = "text"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable}

\item{iv_1_name}{name of the first independent variable}

\item{iv_2_name}{name of the second independent variable}

\item{round_f}{number of decimal places to which to round the
F-statistic from Levene's test (default = 2)}

\item{round_p}{number of decimal places to which to round the
p-value from Levene's test (default = 3)}

\item{output_type}{If \code{output_type = "text"}, the output will be
the results of Levene's test in a text format (i.e., character).
If \code{output_type = "list"}, the output will be the results of
Levene's test in a list format (e.g., p value, F stat, etc. as a list).
By default, \code{output_type = "text"}}
}
\value{
the output of the function depends on the input for
\code{output_type}. By default, the output will be the
results of Levene's test in a text format (i.e., character).
}
\description{
Conduct Levene's test (i.e., test the null hypothesis that the variances
in different gorups are equal)
}
\examples{
\dontrun{
levene_test(
data = mtcars, dv_name = "mpg",
iv_1_name = "vs", iv_2_name = "am")
}
}
