% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfre-package.R
\docType{package}
\name{kfre}
\alias{kfre-package}
\alias{kfre}
\title{kfre: KFRE Risk Prediction Tools (R)}
\description{
Implements the Kidney Failure Risk Equation (KFRE; Tangri et al.) to compute
2- and 5-year risk (4-, 6-, and 8-variable models), add risk columns to data
frames, classify CKD stages/ESRD outcomes, and evaluate & plot performance.
}
\section{Key functions}{

\itemize{
\item \code{\link[=risk_pred_core]{risk_pred_core()}}
\item \code{\link[=add_kfre_risk_col]{add_kfre_risk_col()}}
\item \code{\link[=eval_kfre_metrics]{eval_kfre_metrics()}}, \code{\link[=plot_kfre_metrics]{plot_kfre_metrics()}}
\item \code{\link[=class_esrd_outcome]{class_esrd_outcome()}}, \code{\link[=class_ckd_stages]{class_ckd_stages()}}
}
}

\seealso{
\url{https://github.com/lshpaner/kfre_r}
}
\author{
Leonid Shpaner \email{lshpaner@ucla.edu}
(\href{https://orcid.org/0009-0007-5311-8095}{ORCID}) \cr
\url{https://github.com/lshpaner/kfre_r} \cr
\url{https://www.leonshpaner.com/}
}
