% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.r
\docType{methods}
\name{arithmetic}
\alias{arithmetic}
\alias{+,shaq,shaq-method}
\alias{+,shaq,numeric-method}
\alias{+,numeric,shaq-method}
\alias{-,shaq,shaq-method}
\alias{-,shaq,numeric-method}
\alias{-,numeric,shaq-method}
\alias{*,shaq,shaq-method}
\alias{*,shaq,numeric-method}
\alias{*,numeric,shaq-method}
\alias{/,shaq,shaq-method}
\alias{/,shaq,numeric-method}
\alias{/,numeric,shaq-method}
\title{Arithmetic Operators}
\usage{
\S4method{+}{shaq,shaq}(e1, e2)

\S4method{+}{shaq,numeric}(e1, e2)

\S4method{+}{numeric,shaq}(e1, e2)

\S4method{-}{shaq,shaq}(e1, e2)

\S4method{-}{shaq,numeric}(e1, e2)

\S4method{-}{numeric,shaq}(e1, e2)

\S4method{*}{shaq,shaq}(e1, e2)

\S4method{*}{shaq,numeric}(e1, e2)

\S4method{*}{numeric,shaq}(e1, e2)

\S4method{/}{shaq,shaq}(e1, e2)

\S4method{/}{shaq,numeric}(e1, e2)

\S4method{/}{numeric,shaq}(e1, e2)
}
\arguments{
\item{e1, e2}{A shaq or a numeric vector.}
}
\value{
A shaq.
}
\description{
Some binary arithmetic operations for shaqs.  All operations are
vector-shaq or shaq-vector, but not shaq-shaq.  See details section for more
information.
}
\details{
For binary operations involving two shaqs, they must be distributed
\emph{identically}.
}
\section{Communication}{

Each operation is completely local.
}

\examples{
\dontrun{
library(kazaam)
x = ranshaq(runif, 10, 3)
y = ranshaq(runif, 10, 3)

x + y
x / 2
y + 1

finalize()
}

}
