% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_var_mse.R
\name{bias_AND_scaledvar}
\alias{bias_AND_scaledvar}
\title{Estimators of Bias and Scaled Variance}
\usage{
bias_AND_scaledvar(sigma, Ai, Bj, h, K, fnx, ticker = FALSE)
}
\arguments{
\item{sigma}{Numeric vector \eqn{(\sigma_1, \ldots, \sigma_s)} with
\eqn{s \ge 1}.}

\item{Ai}{Numeric vector expecting \eqn{(x_0 - X_1, \ldots, x_0 - X_n) / h},
where (usually) \eqn{x_0} is the point at which the density is to
be estimated for the data \eqn{X_1, \ldots, X_n} with
\eqn{h = n^{-1/5}}.}

\item{Bj}{Numeric vector expecting \eqn{(-J(1/n), \ldots, -J(n/n))} in case
of the rank transformation method, but \eqn{(\hat{\theta} - X_1,
\ldots, \hat{\theta} - X_n)} in case of the non-robust
Srihera-Stute-method. (Note that this the same as argument
\code{Bj} of \code{\link{adaptive_fnhat}}!)}

\item{h}{Numeric scalar, where (usually) \eqn{h = n^{-1/5}}.}

\item{K}{Kernel function with vectorized in- & output.}

\item{fnx}{\eqn{f_n(x_0) =} \code{mean(K(Ai))/h}, where here typically
\eqn{h = n^{-1/5}}.}

\item{ticker}{Logical; determines if a 'ticker' documents the iteration
progress through \code{sigma}. Defaults to FALSE.}
}
\value{
A list with components \code{BiasHat} and \code{VarHat.scaled}, both
        numeric vectors of same length as \code{sigma}.
}
\description{
``Workhorse'' function for vectorized (in \eqn{\sigma}) computation of both
the bias estimator and the scaled variance estimator of eq. (2.3) in Srihera
& Stute (2011), and for the analogous computation of the bias and scaled
variance estimator for the rank transformation method in the paragraph
after eq. (6) in Eichner & Stute (2013).
}
\details{
Pre-computed \eqn{f_n(x_0)} is expected for efficiency reasons (and is
currently prepared in function \code{adaptive_fnhat}).
}
\examples{
require(stats)

set.seed(2017);     n <- 100;     Xdata <- sort(rnorm(n))
x0 <- 1;      Sigma <- seq(0.01, 10, length = 21)

h <- n^(-1/5)
Ai <- (x0 - Xdata)/h
fnx0 <- mean(dnorm(Ai)) / h   # Parzen-Rosenblatt estimator at x0.

 # non-robust method:
Bj <- mean(Xdata) - Xdata
# # rank transformation-based method (requires sorted data):
# Bj <- -J_admissible(1:n / n)   # rank trafo

kader:::bias_AND_scaledvar(sigma = Sigma, Ai = Ai, Bj = Bj, h = h,
  K = dnorm, fnx = fnx0, ticker = TRUE)

}
\references{
Srihera & Stute (2011) and Eichner & Stute (2013): see
            \link{kader}.
}
