% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ivreg.R
\name{confint.ivreg}
\alias{confint.ivreg}
\alias{summary.ivreg}
\alias{print.summary.ivreg}
\alias{anova.ivreg}
\alias{Anova.ivreg}
\alias{linearHypothesis.ivreg}
\title{Summary and Inference Methods for \code{"ivreg"} Objects}
\usage{
\method{confint}{ivreg}(
  object,
  parm,
  level = 0.95,
  component = c("stage2", "stage1"),
  complete = TRUE,
  vcov. = NULL,
  df = NULL,
  ...
)

\method{summary}{ivreg}(object, vcov. = NULL, df = NULL, diagnostics = NULL, ...)

\method{print}{summary.ivreg}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{anova}{ivreg}(object, object2, test = "F", vcov. = NULL, ...)

\method{Anova}{ivreg}(mod, test.statistic = c("F", "Chisq"), vcov. = NULL, ...)

\method{linearHypothesis}{ivreg}(
  model,
  hypothesis.matrix,
  rhs = NULL,
  test = c("F", "Chisq"),
  vcov. = NULL,
  ...
)
}
\arguments{
\item{object, object2, model, mod}{An object of class \code{"ivreg"}.}

\item{parm}{parameters for which confidence intervals are to be computed; a vector or numbers or names; the default is all parameters.}

\item{level}{confidence level; the default is \code{0.95}.}

\item{component}{Character indicating \code{"stage2"} or \code{"stage1"}.}

\item{complete}{If \code{TRUE}, the default, the returned coefficient vector (for \code{coef}) or coefficient-covariance matrix (for \code{vcov}) includes elements for aliased regressors.}

\item{vcov.}{Optionally either a coefficient covariance matrix or a function to compute such a covariance
matrix from fitted \code{ivreg} model objects. If \code{NULL} (the default) the standard covariance matrix
(based on the information matrix) is used. Alternatively, covariance matrices (e.g., clustered and/or
heteroscedasticity-consistent) can be plugged in to adjust Wald tests or confidence intervals etc.
In \code{summary}, if \code{diagnostics = TRUE}, \code{vcov.} must be a function (not a matrix) because
the alternative covariances are also needed for certain auxiliary models in the diagnostic tests.
If \code{vcov.} is a function, the \code{...} argument can be used to pass on further arguments to
this function.}

\item{df}{For \code{summary}, optional residual degrees of freedom to use in computing model summary.}

\item{...}{arguments to pass down.}

\item{diagnostics}{Report 2SLS "diagnostic" tests in model summary (default is \code{TRUE}). 
These tests are not to be confused with the \emph{regression diagnostics} provided elsewhere in the \pkg{ivreg}
package: see \code{\link{ivregDiagnostics}}.}

\item{x}{An object of class \code{"summary.ivreg"}.}

\item{digits}{Minimal number of significant digits for printing.}

\item{signif.stars}{Show "significance stars" in summary output?}

\item{test, test.statistic}{Test statistics for ANOVA table computed by \code{anova}, \code{\link[car]{Anova}},
or \code{\link[car]{linearHypothesis}}. Only \code{test = "F"} is supported by \code{anova}; this is also
the default for \code{Anova} and \code{linearHypothesis}, which also allow \code{test = "Chisq"} for
asymptotic tests.}

\item{hypothesis.matrix, rhs}{For formulating a linear hypothesis; see the documentation
for \code{\link[car]{linearHypothesis}} for details.}
}
\description{
Summary method, including Wald tests and (by default) certain diagnostic tests, for
\code{"ivreg"} model objects, as well as other related inference functions.
}
\examples{
\dontshow{ if(!requireNamespace("sandwich")) {
  if(interactive() || is.na(Sys.getenv("_R_CHECK_PACKAGE_NAME_", NA))) {
    stop("not all packages required for the example are installed")
  } else q() }}
## data and model
data("CigaretteDemand", package = "ivreg")
m <- ivreg(log(packs) ~ log(rincome) | log(rprice) | salestax, data = CigaretteDemand)

## summary including diagnostics
summary(m)

## replicate global F test from summary (against null model) "by hand"
m0 <- ivreg(log(packs) ~ 1, data = CigaretteDemand)
anova(m0, m)

## or via linear hypothesis test
car::linearHypothesis(m, c("log(rincome)", "log(rprice)"))

## confidence intervals
confint(m)

## just the Wald tests for the coefficients
library("lmtest")
coeftest(m)

## plug in a heteroscedasticity-consistent HC1 covariance matrix (from sandwich)
library("sandwich")
## - as a function passing additional type argument through ...
coeftest(m, vcov = vcovHC, type = "HC1")
## - as a function without additional arguments
hc1 <- function(object, ...) vcovHC(object, type = "HC1", ...)
coeftest(m, vcov = hc1)
## - as a matrix
vc1 <- vcovHC(m, type = "HC1")
coeftest(m, vcov = vc1)

## in summary() with diagnostics = TRUE use one of the function specifications,
## the matrix is only possible when diagnostics = FALSE
summary(m, vcov = vcovHC, type = "HC1")     ## function + ...
summary(m, vcov = hc1)                      ## function
summary(m, vcov = vc1, diagnostics = FALSE) ## matrix

## in confint() and anova() any of the three specifications can be used
anova(m0, m, vcov = vcovHC, type = "HC1")   ## function + ...
anova(m0, m, vcov = hc1)                    ## function
anova(m0, m, vcov = vc1)                    ## matrix

}
\seealso{
\code{\link{ivreg}}, \code{\link{ivreg.fit}}, \code{\link{ivregDiagnostics}}
}
