#' Partly Artificial Data on the U.S. Economy
#'
#' These are partly contrived data from Kmenta (1986), constructed
#' to illustrate estimation of a simultaneous-equation econometric model. The data
#' are an annual time-series for the U.S. economy from 1922 to 1941. The values of the
#' exogenous variables D, and F, and A are real, while those of the endogenous
#' variables Q and P are simulated according to the linear simultaneous equation model 
#' fit in the examples.
#'
#' @usage data("Kmenta", package = "ivreg")
#'
#' @format A data frame with 20 rows and 5 columns.
#' \describe{
#'   \item{Q}{food consumption per capita.}
#'   \item{P}{ratio of food prices to general consumer prices.}
#'   \item{D}{disposable income in constant dollars.}
#'   \item{F}{ratio of preceding year's prices received by farmers to general consumer prices.}
#'   \item{A}{time in years.}
#'   }
#'
#' @source Kmenta, J. (1986) \emph{Elements of Econometrics}, 2nd ed., Macmillan.
#' @seealso \code{\link{ivreg}}.
#'
#' @examples
#' data("Kmenta", package = "ivreg") 
#' deq <- ivreg(Q ~ P + D     | D + F + A, data = Kmenta) # demand equation
#' seq <- ivreg(Q ~ P + F + A | D + F + A, data = Kmenta) # supply equation
#' summary(deq, tests = TRUE)
#' summary(seq, tests = TRUE)
"Kmenta"
