% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipu_nr.R
\name{create_target_priority}
\alias{create_target_priority}
\title{Create a named list of target priority levels.}
\usage{
create_target_priority(target_priority, targets)
}
\arguments{
\item{target_priority}{This argument controls how quickly each set of 
  targets is relaxed. In other words: how important it is to match the target
  exactly. Defaults to \code{10,000,000}, which means that all targets should
  be matched exactly.

\describe{
  \item{\code{real}}{This priority value will be used for each target table.}
  \item{\code{named list}}{Each named entry must match an entry in either
  \code{primary_targets} or \code{secondary_targets} and have a \code{real}.
  This priority will be applied to that target table. Any targets not in the
  list will default to \code{10,000,000}.}
  \item{\code{data.frame}}{Column \code{target} must have values that match an
  entry in either \code{primary_targets} or \code{secondary_targets}. Column 
  \code{priority} contains the values to use for priority. Any targets not in
  the table will default to \code{10,000,000}.}
}}

\item{targets}{The complete list of targets (both primary and secondary)}
}
\description{
Create a named list of target priority levels.
}
\keyword{internal}
