% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervalaverage_functions.R
\name{CJ.dt}
\alias{CJ.dt}
\title{grid expand an arbitrary number of data.tables}
\usage{
CJ.dt(..., groups = NULL)
}
\arguments{
\item{...}{data.tables}

\item{groups}{a character vector corresponding to
column names of grouping vars in all of the data.tables}
}
\description{
similar to data.table::CJ and base::expand.grid except for rows of data.tables.
}
\details{
CJ.dt computes successive cartesian join over rows of each table
paying no attention to whatever the tables are keyed on.
}
\examples{
#' CJ.dt(data.table(c(1,2,2),c(1,1,1)),data.table(c("a","b"),c("c","d")))
#If you want to expand x to unique values of a non-unique columns in y
x <- data.table(c(1,2,3),c("a","b","b"))
y <- data.table(id=c(1,2,2,1,3),value=c(2,4,1,7,3))
z <- CJ.dt(x, y[,list(id=unique(id))])
#if you want to merge this back to y
y[z,on="id",allow.cartesian=TRUE] #or z[y,on="id",allow.cartesian=TRUE]
}
