% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_data_.R
\name{inspect_data_dichotomous}
\alias{inspect_data_dichotomous}
\title{Validate dichotomous data}
\usage{
inspect_data_dichotomous(data, success, allow_nas = TRUE, warning_nas = FALSE)
}
\arguments{
\item{data, success}{Arbitrary objects. \code{success} is meant to indicate the
value of \code{data} that corresponds to a success.}

\item{allow_nas}{Logical value. If \code{TRUE} then \code{NA} and \code{NaN} values in
\code{data} are allowed. If \code{FALSE}, execution is stopped and an error message is
thrown in case there are \code{NA} or \code{NaN} values in \code{data}.}

\item{warning_nas}{Logical value. If \code{TRUE} then the presence of \code{NA} or
\code{NaN} values in \code{data} generates a warning message. \code{NA} and \code{NaN} values
pass silently otherwise (if \code{allow_nas} is set to\code{TRUE}).}
}
\value{
\code{inspect_data_dichotomous} does not return any output. There are
three possible outcomes:
\itemize{
\item The call is silent if:
\itemize{
\item \code{data} is eligible to have been generated by a series of Bernoulli trials
and there are no \code{NA} or \code{NaN} values in \code{data}.
\item \code{data} is eligible to have been generated by a series of Bernoulli
trials, there are some \code{NA} or \code{NaN} values in \code{data}, \code{allow_nas} is set
to \code{TRUE} and \code{warning_nas} is set to \code{FALSE}.
}
\item An informative warning message is thrown if:
\itemize{
\item \code{data} is eligible to have been generated by a series of Bernoulli trials
and \code{success} is not observed in \code{data}.
\item \code{data} is eligible to have been generated by a series of Bernoulli
trials, there are \code{NA} or \code{NaN} values in \code{data} and both \code{allow_nas} and
\code{warning_nas} are set to \code{TRUE}.
}
\item An informative error message is thrown and the execution is stopped if:
\itemize{
\item \code{data} is not eligible to have been generated by a series of Bernoulli
trials.
\item \code{data} is eligible to have been generated by a series of Bernoulli
trials, there are some \code{NA} or \code{NaN} values in \code{data} and \code{allow_nas} is
set to \code{FALSE}.
}
}
}
\description{
\code{inspect_data_dichotomous} checks if an object contains data
that is eligible to have been generated by a series of Bernoulli trials. This
can be useful to validate inputs in user-defined functions.
}
\details{
\code{inspect_data_dichotomous} conducts a series of tests to check if
\code{data} is eligible to have been generated by a series of Bernoulli trials.
Namely, \code{inspect_data_dichotomous} checks if:
\itemize{
\item \code{data} and \code{success} are \code{NULL} or empty.
\item \code{data} and \code{success} are atomic and have an eligible data type (logical,
integer, double, character).
\item \code{data} and \code{success} have \code{NA} or \code{NaN} values.
\item The number of unique values in \code{data} and \code{success} are adequate.
\item \code{success} has \code{\link[base]{length}} 1.
\item \code{success} is observed in \code{data}.
}
}
\examples{
# Calls that pass silently:
x1 <- c(1, 0, 0, 1, 0)
x2 <- c(FALSE, FALSE, TRUE)
x3 <- c("yes", "no", "yes")
x4 <- factor(c("yes", "no", "yes"))
x5 <- c(1, 0, 0, 1, 0, NA)
inspect_data_dichotomous(x1, success = 1)
inspect_data_dichotomous(x2, success = TRUE)
inspect_data_dichotomous(x3, success = "yes")
inspect_data_dichotomous(x4, success = "yes")
inspect_data_dichotomous(x5, success = 1)

# Calls that throw an informative warning message:
y1 <- c(1, 1, NA, 0, 0)
y2 <- c(0, 0)
success <- 1
try(inspect_data_dichotomous(y1, success = 1, warning_nas = TRUE))
try(inspect_data_dichotomous(y2, success = success))

# Calls that throw an informative error message:
try(inspect_data_dichotomous(NULL, 1))
try(inspect_data_dichotomous(c(1, 0), NULL))
try(inspect_data_dichotomous(list(1, 0), 1))
try(inspect_data_dichotomous(c(1, 0), list(1)))
try(inspect_data_dichotomous(numeric(0), 0))
try(inspect_data_dichotomous(1, numeric(0)))
try(inspect_data_dichotomous(NaN, 1))
try(inspect_data_dichotomous(NA, 1))
try(inspect_data_dichotomous(c(1, 0), NA))
try(inspect_data_dichotomous(c(1, 0), NaN))
try(inspect_data_dichotomous(c(1, 0), 2))
}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_par_bernoulli}} to validate
Bernoulli/Binomial proportions.
\item \code{\link[inspector]{inspect_data_categorical}} and
\code{\link[inspector]{inspect_data_cat_as_dichotom}} to validate categorical
data.
\item \code{\link[inspector]{inspect_par_multinomial}} to validate vectors of
Multinomial proportions.
}
}
