% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variable_profile.R
\name{calculate_variable_split}
\alias{calculate_variable_split}
\alias{calculate_variable_split.default}
\title{Internal Function for Split Points for Selected Variables}
\usage{
calculate_variable_split(
  data,
  variables = colnames(data),
  grid_points = 101,
  variable_splits_type = "quantiles",
  new_observation = NA
)

\method{calculate_variable_split}{default}(
  data,
  variables = colnames(data),
  grid_points = 101,
  variable_splits_type = "quantiles",
  new_observation = NA
)
}
\arguments{
\item{data}{validation dataset. Is used to determine distribution of observations.}

\item{variables}{names of variables for which splits shall be calculated}

\item{grid_points}{number of points used for response path}

\item{variable_splits_type}{how variable grids shall be calculated? Use "quantiles" (default) for percentiles or "uniform" to get uniform grid of points}

\item{new_observation}{if specified (not \code{NA}) then all values in \code{new_observation} will be included in \code{variable_splits}}
}
\value{
A named list with splits for selected variables
}
\description{
This function calculate candidate splits for each selected variable.
For numerical variables splits are calculated as percentiles
(in general uniform quantiles of the length grid_points).
For all other variables splits are calculated as unique values.
}
\details{
Note that \code{\link{calculate_variable_split}} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
