% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_industRial.R
\name{theme_industRial}
\alias{theme_industRial}
\title{Custom theme "industRial" for the book industRial Data Science plots}
\usage{
theme_industRial(
  font_size = 14,
  font_family = "",
  line_size = 0.5,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14,
  base_size = font_size,
  base_family = font_family
)
}
\arguments{
\item{font_size}{defaults to 14}

\item{font_family}{defaults to ""}

\item{line_size}{defaults to 0.5}

\item{rel_small}{defaults to 12/14}

\item{rel_tiny}{defaults to 11/14}

\item{rel_large}{defaults to 16/14}

\item{base_size}{internal arguments, defaults to font_size}

\item{base_family}{internal arguments, defaults to font_family}
}
\value{
This function returns an object of classes theme and gg from the ggplot2 package
}
\description{
This theme aims at optimal balance between readability and precision. It has 
adapted from the package {cowplot} by Claus O.Wilke and reflects the principles
of his book \href{https://clauswilke.com/dataviz/}{Fundamentals of Data Visualization }
}
\details{
Apply this theme by adding it at the end of the code of any \code{\link[ggplot2]{ggplot}} chart.
It basically combines the half open theme with a grid background from {cowplot}
}
\examples{
library(dplyr)
library(ggplot2)

pet_delivery \%>\% 
   ggplot(aes(x = A)) +
   geom_histogram(color = "grey", fill = "grey90") +
   labs(title = "PET clothing case study",
      subtitle = "Raw data plot",
      x = "Treatment",
      y = "Tensile strength [MPa]") +
      theme_industRial()
}
\references{
For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
}
