% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_model.R
\name{scan_spline_lam}
\alias{scan_spline_lam}
\title{Scan spline regularization parameter}
\usage{
scan_spline_lam(
  reported,
  delay_dist,
  lam_grid,
  method = "val",
  percent_thresh = 2,
  dof = 10,
  regularization_order = 2,
  reported_val = NULL,
  end_pad_size = 0,
  fisher_approx_cov = TRUE
)
}
\arguments{
\item{reported}{An integer vector of reported cases.}

\item{delay_dist}{A positive vector that sums to one, which describes the delay distribution.}

\item{lam_grid}{A vector of regularization strengths to scan.}

\item{method}{Metric to choose "best" dof: 'aic', 'bic', 'val'.
If method='val', reported_val must be non NULL and match reported size.}

\item{percent_thresh}{If using validation likelihood to select best,
the largest (strongest) lambda that is within `percent_thresh` of
the highest validation lambda will be selected. Default is 2. Must be greater than 0.}

\item{dof}{Degrees of freedom for spline basis.}

\item{regularization_order}{An integer (typically 0, 1, 2), indicating differencing order for L2 
regularization of spline parameters. Default is 2 for second derivative penalty.}

\item{reported_val}{Validation time series of equal size
to reported vector for use with 'val' method. Default is NULL.}

\item{end_pad_size}{And integer number of steps the spline is defined beyond the final 
observation.}

\item{fisher_approx_cov}{A flag to use either the Fisher Information (TRUE) or the Hessian (FALSE) to approx posterior covariance over parameters.}
}
\value{
List of outputs:\itemize{
\item best_lam = best lambda
\item lam_resdf = data frame of fit statistics (lambda, dof, aic, bic, val_lls, train_lls)}
}
\description{
This function holds degrees of freedom fixed and scans regularization parameter values.
}
