#ifndef MIN_ENTROPY_HPP
#define MIN_ENTROPY_HPP

#include <RcppArmadillo.h>

namespace min_entropy {
    
    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = log(wt / adjwt);
        df = adjwt % df + wt- adjwt;
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        return log(adjwt / wt);
    }

}

#endif // MIN_ENTROPY_HPP
