% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/u_net_plusplus.R
\name{u_net_plusplus}
\alias{u_net_plusplus}
\title{Create a U-Net++ architecture}
\usage{
u_net_plusplus(
  net_h,
  net_w,
  grayscale = FALSE,
  blocks = 4,
  n_class = 1,
  filters = 16,
  kernel_initializer = "he_normal"
)
}
\arguments{
\item{net_h}{Input layer height.}

\item{net_w}{Input layer width.}

\item{grayscale}{Defines input layer color channels - 1 if `TRUE`, 3 if `FALSE`.}

\item{blocks}{Number of blocks in the model.}

\item{n_class}{Number of classes.}

\item{filters}{Integer, the dimensionality of the output space (i.e. the number of output filters in the convolution).}

\item{kernel_initializer}{Initializer for the kernel weights matrix.}
}
\value{
U-Net++ model.
}
\description{
Create a U-Net++ architecture.
}
\details{
The function was ported to R from Python code in https://github.com/albertsokol/pneumothorax-detection-unet/blob/master/models.py. For more details, see https://github.com/MrGiovanni/UNetPlusPlus.
}
\examples{
\dontrun{
# U-Net++ model for 256x256 pixel RGB input images with a single output class

model <- u_net_plusplus(net_h = 256, 
net_w = 256, 
filters = 32,
blocks = 3 
)
 
model

}

}
