% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/u_net.R
\name{u_net}
\alias{u_net}
\title{Create a U-Net architecture}
\usage{
u_net(
  net_h,
  net_w,
  grayscale = FALSE,
  layers_per_block = 2,
  blocks = 4,
  n_class = 1,
  filters = 16,
  dropout = 0,
  batch_normalization = TRUE,
  kernel_initializer = "he_normal"
)
}
\arguments{
\item{net_h}{Input layer height.}

\item{net_w}{Input layer width.}

\item{grayscale}{Defines input layer color channels - 1 if `TRUE`, 3 if `FALSE`.}

\item{layers_per_block}{Number of convolutional layers per block (can be 2 or 3)}

\item{blocks}{Number of blocks in the model.}

\item{n_class}{Number of classes.}

\item{filters}{Integer, the dimensionality of the output space (i.e. the number of output filters in the convolution).}

\item{dropout}{Dropout rate (between 0 and 1).}

\item{batch_normalization}{Should batch normalization be used in the block?}

\item{kernel_initializer}{Initializer for the kernel weights matrix.}
}
\value{
U-Net model.

A keras model as returned by \code{\link[keras]{keras_model}}
}
\description{
Create a U-Net architecture
}
\details{
This function creates a U-Net model architecture according to user input. It allows flexibility regarding input, output and the hidden layers. 
See the package vignette for examples.

The function was adapted and slightly modified from the \code{u_net()} function in the platypus package (\url{https://github.com/maju116/platypus/blob/master/R/u_net.R}).

Differences compared to platypus implementation:

\itemize{
\item added argument: layers_per_block (can be 2 or 3) 
\item kernel size in layer_conv_2d_transpose is 2, not 3.
\item dropout layers are only included if user specifies dropout > 0
\item n_class = 1 by default (sufficient for binary classification used for vegetation model, e.g. sky or not sky)
\item automatic choice of activation of output layer: "sigmoid" if n_class = 1, otherwise "softmax"
\item allows non-square input images (e.g. 160x256 used in understory vegetation density model)
}
}
\examples{
\dontrun{
# U-Net model for 256x256 pixel RGB input images with a single output class
# this model was used for canopy density

model <- u_net(net_h = 256, 
net_w = 256, 
grayscale = FALSE,
filters = 32,
blocks = 4,
layers_per_block = 2
)

# several arguments above were not necessary because they were kept at their default. 
# Below is the same model, but shorter:

model <- u_net(net_h = 256, 
net_w = 256, 
filters = 32
)

model

}

}
