% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageSegmentation.R
\name{imageSegmentation}
\alias{imageSegmentation}
\title{Model predictions from images based on TensorFlow model}
\usage{
imageSegmentation(
  model,
  x,
  dirOutput,
  dirExamples,
  subsetArea,
  threshold = 0.5,
  returnInput = FALSE
)
}
\arguments{
\item{model}{trained model to use in predictions}

\item{x}{array of images as model input (can be created with \code{\link{imagesToKerasInput}})}

\item{dirOutput}{character. Directory to save output images to (optional)}

\item{dirExamples}{character. Directory to save example classification to (optional)}

\item{subsetArea}{If "circle", vegetation density will be calculated for a circular area in the center of the predicted images. Can also be a number between 0 and 1 (to scale the circle relative to the image dimensions), or a matrix of 0 and 1 in the same dimensions as images in x.}

\item{threshold}{numeric value at which to split binary predictions. Can be useful to only return high-confidence pixels in predictions. It is not relevant for multi-class predictions.}

\item{returnInput}{logical. If \code{dirOutput} is defined, save input images alongside output?}
}
\value{
A list. The type and number of list items depends on the classification. For binary classifications (1 prediction class), the following list items are returned:

\itemize{
\item image (input images)
\item prediction (model prediction)
\item prediction_binary (binary prediction, only 0 or 1)
\item examples (images with their image segmentation results)
\item summary (data frame with fraction of image predicted)
\item mask (an image showing the area for which summary statistics were calculated (in white, only if \code{subsetArea} is defined)
}

in multi-class models:

\itemize{
\item image (input images)
\item prediction_most_likely (the class with the highest probability, coded in grayscale)
\item class1 - classX: for each class, the predicted probabilities
\item examples (images with their image segmentation results)
\item summary (data frame with fraction of image covered by vegetation (black)).
\item mask (an image showing the area for which summary statistics were calculated (in white, only if \code{subsetArea} is defined)
}
}
\description{
This function uses a pre-trained TensorFlow model to create predictions from input data. It was mainly designed to predict canopy cover and understory vegetation density from forest habitat photographs using the pre-trained models we provide.
}
\details{
By default, vegetation density will be calculated across the entire input images. If canopy images are hemispherical and have black areas in the corner that should be ignored, set \code{subsetArea} to "circle". If the relevant section of the images is smaller than the image frame, give a number between 0 and 1 (indicating how big the circle is, relative to the image dimensions).
Alternatively, provide a custom matrix of 0 and 1 in the same dimensions as the input images in x. 0 indicates areas to ignore in the vegetation calculations, 1 is included. \code{subsetArea = "circle"} only works if input images in x are square.

The canopy density models predicts sky and the understory vegetation density model predicts the red flysheet The percentage of these is equivalent to openness (canopy openness or understory openness). This value is in the column "predicted".

 The interpretation of openness depends on context:

\itemize{
\item Canopy Cover images: openness = Gap Fraction and Fraction Soil
\item Hemispherical canopy images: openness = Canopy openness and site openness (in flat terrain)
}
See e.g. Gonsamo et al. (2013) for more details.

Generally speaking, "predicted" is the percentage of the image that is 1 in the binary prediction.


The column "not_predicted" is the opposite (1-predicted). It is thus equivalent to vegetation density in the two vegetation models.

Depending on the context, "not_predicted" can for example mean: canopy cover, canopy closure, understory vegetation density.
In canopy cover images, the vegetation density corresponds to canopy cover. In hemispherical images, vegetation density corresponds to canopy closure.
}
\examples{

\dontrun{

# Example 1: Canopy
wd_images <- system.file("images/canopy/resized",
                         package = "imageseg")
images <- loadImages(imageDir = wd_images)
x <- imagesToKerasInput(images)

wd_model_can <- "C:/Path/To/Model"      # change this
filename_model_can <- "imageseg_canopy_model.hdf5"
model_can <- loadModel(file.path(wd_model_can, filename_model_can))


results_can <- imageSegmentation(model = model_can,
                                 x = x)
results_can$image
results_can$prediction
results_can$prediction_binary
results_can$vegetation


# Example 2: Understory
wd_images_us <- system.file("images/understory/resized",
                             package = "imageseg")
images_us <- loadImages(imageDir = wd_images_us)
x <- imagesToKerasInput(images_us)

# note, here we just specify the complete path, not separate by directory and file name as above
model_file_us <- "C:/Path/To/Model/imageseg_understory_model.hdf5"
model_us <- loadModel(model_file_us)

results_us <- imageSegmentation(model = model_us,
                                x = x)
results_us$image
results_us$prediction
results_us$prediction_binary
results_us$vegetation

}

}
