test_that("archive functions ok", {
  object <- ichimoku(sample_ohlc_data)
  file <- tempfile()
  expect_message(archive(object = object, file = file), "Archive written")
  expect_message(archive(object, file), "Archive written")
  expect_message(restored <- archive(file = file), "Archive read")
  expect_message(restored <- archive(, file), "Archive read")
  unlink(file)
  expect_identical(restored, object)
  expect_error(archive(object, object, object), "3 arguments passed")
  expect_error(archive(object), "supplied as a string")
  expect_error(archive(object, object), "supplied as a string")
  expect_error(archive(object = object), "specified without")
  expect_error(archive(,), "Empty arguments")
  expect_error(archive(), "0 arguments")
  file <- tempfile()
  save(sample_ohlc_data, file = file)
  expect_error(archive(file), "was not created")
  unlink(file)
  x_archive_secure_hash <- "010101010101"
  file <- tempfile()
  save(object, x_archive_secure_hash, file = file)
  expect_warning(expect_message(restored <- archive(file), "Archive read"), "does not match the original")
  unlink(file)
})
