% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.ichimoku}
\alias{summary.ichimoku}
\title{Summary of Ichimoku Objects and Strategies}
\usage{
\method{summary}{ichimoku}(object, strat = TRUE, ...)
}
\arguments{
\item{object}{an object of class \sQuote{ichimoku}.}

\item{strat}{[default TRUE] to show the strategy summary if present. Set to
FALSE to show the object summary instead.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A matrix containing the strategy summary, if present and
    \sQuote{strat} is set to TRUE, otherwise a character vector containing an
    abbreviated object summary (the full object summary is output to the
    console).
}
\description{
Display summary information for an ichimoku object or its strategy.
}
\details{
This function is an S3 method for the generic function summary() for
    class \sQuote{ichimoku}. It can be invoked by calling summary(x) on an
    object \sQuote{x} of class \sQuote{ichimoku}.

    Performs basic validation for an ichimoku object and will inform if an
    ichimoku object contains invalid information.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
summary(cloud)

strat <- strat(cloud)
summary(strat)

}
