% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodeTypeRelation.R
\name{getCodeTypeRelation}
\alias{getCodeTypeRelation}
\title{Get Details}
\usage{
getCodeTypeRelation(code_type, linked_code_type, rename = TRUE)
}
\arguments{
\item{code_type}{an ICES Vocabulary code type.}

\item{linked_code_type}{another ICES Vocabulary code type.}

\item{rename}{logical, if TRUE (default) the columns of the output
is renamed to the code type and linked code type}
}
\value{
A data frame.
}
\description{
Get details for a given code.
}
\examples{
\dontrun{
x <- getCodeTypeRelation("Pargroup", "PARAM")

# get all stocks in subarea 4a
# note you would need to cross check with icesSD for
# currently active stocks
lookup <- getCodeTypeRelation("ICES_Area", "ICES_StockCode")
lookup[lookup$ICES_Area == "27.4.a", ]

# get relation between stock code and area, unformatted output
lookup_raw <- getCodeTypeRelation("ICES_StockCode", "ICES_Area", rename = FALSE)
head(lookup_raw)
}
}
\seealso{
\code{\link{getCodeTypeList}} and \code{\link{getCodeList}} get code types
and codes of a given type.

\code{\link{icesVocab-package}} gives an overview of the package.
}
