% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliar_functions.R
\name{plot.GOF}
\alias{plot.GOF}
\title{Goodness of fit plots}
\usage{
\method{plot}{GOF}(x, type = c("all", "envelope", "dispersion", "zeros"), ...)
}
\arguments{
\item{x}{An object of class \emph{GOF} generated by \emph{GOF_check} function.}

\item{type}{Which plot to draw. Values: \emph{all} (default); \emph{envelope} for envelopes of randomized quantile residuals; \emph{dispersion} for plot to assess the dispersion; \emph{zeros} for plot to assess the zero inflation.}

\item{...}{Ignore}
}
\description{
Draws the plots to assess the goodness of fit
}
\examples{
\donttest{
# Poisson model. Repeatability setting.
iccpois<-icc_counts(EPP,y="Social",id="id")
iccpois.gof<-GOF_check(iccpois)
plot(iccpois.gof)
plot(iccpois.gof,type="envelope")
plot(iccpois.gof,type="dispersion")
plot(iccpois.gof,type="zeros")
}
}
\seealso{
\code{\link[=GOF_check]{GOF_check()}}
}
