% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_functions.R
\name{DispersionTest}
\alias{DispersionTest}
\title{Dispersion test for GLMM}
\usage{
DispersionTest(x)
}
\arguments{
\item{x}{An object of class \emph{GOF} generated by \emph{GOF_check} function.}
}
\value{
A vector with the sample RQR dispersion and the P-value.
}
\description{
Dispersion test for GLMM
}
\details{
The function prints the dispersion of sample randomized quantile residuals (RQR) and the simulated P-value.
}
\examples{
\donttest{
# Poisson model. Repeatability setting.
iccpois<-icc_counts(EPP,y="Social",id="id")
iccpois.gof<-GOF_check(iccpois)
DispersionTest(iccpois.gof)
}
}
\seealso{
\code{\link[=GOF_check]{GOF_check()}}
}
