% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOnset.R
\name{getOnset}
\alias{getOnset}
\title{Extracting Daily Climatic Variables Based on Onset of Planting}
\usage{
getOnset(sites, crop, var, cv = FALSE)
}
\arguments{
\item{sites}{character. Names of sites from which to extract data.}

\item{crop}{character. Crop code in ICARDA database. See section 'Details' for a list of crops.}

\item{var}{character. Climatic variable(s) to be extracted.}

\item{cv}{boolean. If \code{TRUE}, returns a data frame with coefficient of variation for each variable for each day of the onset year. Default: FALSE.}
}
\value{
An object of class "data.frame" with specified climatic variables for names in \code{sites}.

If \code{cv = TRUE}, the object is a list containing three data frames: the first one with average daily values of climatic variables, the second one with daily coefficient of variation for each climatic variable, and the third one with phenotypic variables and number of day in calendar year when each occurs at the sites specified in \code{sites}.

If \code{cv = FALSE}, the object is a list containing two data frames: the first one with average daily values of climatic variables, and the second one with phenotypic variables and number of day in calendar year when each occurs at the sites specified in \code{sites}.
}
\description{
this function Extracts Daily values of climatic variables from remote ICARDA data based on Onset of Planting, it returns a list based on specified climatic variables. Each variable will have 365 values for each day of the (onset) year beginning with planting day.
}
\details{
Similar to \code{\link[icardaFIGSr]{getDaily}} except the extracted data is based on 365 days starting from the onset of planting.
Crops available in ICARDA's genebank documentation system include the following:
\itemize{
  \item{'ICAG' = Aegilops}
  \item{'ICB' = Barley}
  \item{'ICBW' = Bread wheat}
  \item{'ILC' = Chickpea}
  \item{'ICDW' = Durum wheat}
  \item{'ILB' = Faba bean}
  \item{'BPL' = Faba bean BPL}
  \item{'IFMI' = Forage and range}
  \item{'IFLA' = Lathyrus}
  \item{'ILL' = Lentil}
  \item{'IFMA' = Medicago annual}
  \item{'IC' = Not mandate cereals}
  \item{'IFPI' = Pisum}
  \item{'ICPW' = Primitive wheat}
  \item{'IFTR' = Trifolium}
  \item{'IFVI' = Vicia}
  \item{'ICWH' = Wheat hybrids}
  \item{'ICWW' = Wheat wild relatives}
  \item{'ILWC' = Wild Cicer}
  \item{'ICWB' = Wild Hordeum}
  \item{'ILWL' = Wild Lens}
  \item{'ICWT' = Wild Triticum}
 }

 Alternatively, the list of available crops can be fetched from ICARDA's online server using \code{\link[icardaFIGSr]{getCrops}}.
}
\examples{
if(interactive()){
 # Extract onset data for durum wheat
 durum <- getAccessions(crop = 'Durum wheat', coor = TRUE)
 onset <- getOnset(sites = levels(as.factor(durum$SiteCode)), crop = 'ICDW',
                   var = c('tavg', 'prec', 'rh'), cv = TRUE)

 # Get data frame with climatic variables from list object returned
 onset.clim <- onset[[1]]

 # Get data frame with coefficient of variation from list object
 # returned (when cv = TRUE)
 onset.cv <- onset[[2]]

 # Get data frame with phenotypic variables from list object returned
 onset.pheno <- onset[[3]]
 }
}
\seealso{
\code{\link[reshape2]{dcast}},
 \code{\link[icardaFIGSr]{getCrops}}
}
\author{
Khadija Aouzal, Amal Ibnelhobyb, Zakaria Kehel, Bancy Ngatia
}
