% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_interactions.R
\name{local_interactions}
\alias{local_interactions}
\alias{local_interactions.explainer}
\alias{local_interactions.default}
\title{Model Agnostic Sequential Variable Attributions with Interactions}
\usage{
local_interactions(x, ...)

\method{local_interactions}{explainer}(x, new_observation, keep_distributions = FALSE, ...)

\method{local_interactions}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  label = class(x)[1],
  keep_distributions = FALSE,
  order = NULL,
  interaction_preference = 1,
  ...
)
}
\arguments{
\item{x}{an explainer created with function \code{\link[DALEX]{explain}} or a model.}

\item{...}{other parameters.}

\item{new_observation}{a new observation with columns that correspond to variables used in the model.}

\item{keep_distributions}{if \code{TRUE}, then the distribution of partial predictions is stored in addition to the average.}

\item{data}{validation dataset, will be extracted from \code{x} if it's an explainer.}

\item{predict_function}{predict function, will be extracted from \code{x} if it's an explainer.}

\item{label}{character - the name of the model. By default it's extracted from the 'class' attribute of the model.}

\item{order}{if not \code{NULL}, then it will be a fixed order of variables. It can be a numeric vector or vector with names of variables/interactions.}

\item{interaction_preference}{an integer specifying which interactions will be present in an explanation. The larger the integer, the more frequently interactions will be presented.}
}
\value{
an object of the \code{break_down} class.
}
\description{
This function implements decomposition of model predictions with identification
of interactions.
The complexity of this function is O(2*p) for additive models and O(2*p^2) for interactions.
This function works in a similar way to step-up and step-down greedy approximations in function \code{break_down()}.
The main difference is that in the first step the order of variables and interactions is determined.
And in the second step the impact is calculated.
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

bd_glm <- local_interactions(explain_titanic_glm, titanic_imputed[1, ],
       interaction_preference = 500)
bd_glm
plot(bd_glm, max_features = 2)

\dontrun{
library("randomForest")
# example with interaction
# classification for HR data
model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                 data = HR[1:1000,1:5])

bd_rf <- local_interactions(explainer_rf,
                 new_observation)

bd_rf
plot(bd_rf)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
         data = apartments_test[1:1000,2:6],
         y = apartments_test$m2.price[1:1000])

new_observation <- apartments_test[1,]

bd_rf <- local_interactions(explainer_rf,
                 new_observation,
                 keep_distributions = TRUE)

bd_rf
plot(bd_rf)
plot(bd_rf, plot_distributions = TRUE)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://ema.drwhy.ai}
}
\seealso{
\code{\link{break_down}}, \code{\link{local_attributions}}
}
