% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break_down_uncertainty.R
\name{break_down_uncertainty}
\alias{break_down_uncertainty}
\alias{break_down_uncertainty.explainer}
\alias{break_down_uncertainty.default}
\alias{shap}
\title{Explanation Level Uncertainty of Sequential Variable Attribution}
\usage{
break_down_uncertainty(x, ..., keep_distributions = TRUE, B = 10)

\method{break_down_uncertainty}{explainer}(
  x,
  new_observation,
  ...,
  keep_distributions = TRUE,
  B = 10
)

\method{break_down_uncertainty}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  label = class(x)[1],
  ...,
  path = NULL,
  keep_distributions = TRUE,
  B = 10
)

shap(x, ..., B = 25)
}
\arguments{
\item{x}{an explainer created with function \code{\link[DALEX]{explain}} or a model.}

\item{...}{other parameters.}

\item{keep_distributions}{if \code{TRUE} then we will keep distribution for predicted values. It's needed by the describe function.}

\item{B}{number of random paths}

\item{new_observation}{a new observation with columns that correspond to variables used in the model.}

\item{data}{validation dataset, will be extracted from \code{x} if it is an explainer.}

\item{predict_function}{predict function, will be extracted from \code{x} if it is an explainer.}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model.}

\item{path}{if specified, then this path will be highlighed on the plot. Use \code{average} in order to show an average effect}
}
\value{
an object of the \code{break_down_uncertainty} class.
}
\description{
This function calculates the break down algorithm for \code{B} random orderings.
Then it calculates the distribution of attributions for these different orderings.
Note that the \code{shap()} function is just a simplified interface to the \code{break_down_uncertainty()} function
with a default value set to \code{B=25}.
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed,
                               y = titanic_imputed$survived,
                           label = "glm")

# there is no explanation level uncertanity linked with additive models
bd_glm <- break_down_uncertainty(explain_titanic_glm, titanic_imputed[1, ])
bd_glm
plot(bd_glm)

\dontrun{
## Not run:
library("randomForest")
set.seed(1313)
model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000, 1:5])

bd_rf <- break_down_uncertainty(explainer_rf,
                           new_observation)
bd_rf
plot(bd_rf)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000, 2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- break_down_uncertainty(explainer_rf, apartments_test[1,])
bd_rf
plot(bd_rf)

bd_rf <- break_down_uncertainty(explainer_rf, apartments_test[1,], path = 1:5)
plot(bd_rf)

bd_rf <- break_down_uncertainty(explainer_rf,
                                     apartments_test[1,],
                                     path = c("floor", "no.rooms", "district",
                                         "construction.year", "surface"))
plot(bd_rf)

bd <- break_down(explainer_rf,
                    apartments_test[1,])
plot(bd)

s <- shap(explainer_rf,
                   apartments_test[1,])
plot(s)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://ema.drwhy.ai}
}
\seealso{
\code{\link{break_down}}, \code{\link{local_attributions}}
}
