% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{z_sim}
\alias{z_sim}
\title{Simulate the threshold/control variable Z}
\usage{
z_sim(n_t, n_switches, start_regime = 0, start_hyst = FALSE, range = c(-1, 1))
}
\arguments{
\item{n_t}{The desired length of the simulated time series of \code{z}. The actual
vector that is returned will contain 10 more time points, see Details.
Note that \code{n_t} will also be the length of \code{y}, when you feed \code{z} to \code{\link{hystar_sim}}.}

\item{n_switches}{A scalar indicating the desired number of regime switches.
Basically, it is the number of times the variable moves to (and reaches) its
minimum or to its maximum. If the thresholds are within the range of \code{z},
as they should, this will guarantee the same number of regime switches when
the delay parameter of the HysTAR model is greater or equal than the highest order.
See Details.}

\item{start_regime}{The starting regime of the HysTAR model, 0 (default) or 1.}

\item{start_hyst}{Logical, should \code{z} start in the hysteresis zone? Of course, this also
depends on \code{r}, and \code{r} is not yet specified in this function. Rather, setting \code{start_hyst}
to \code{TRUE} makes \code{z} start at in the middle of its range, which makes it easy to
set the threshold values "around" the first values of \code{z}.}

\item{range}{A numeric vector of length 2 indicating the desired range (min, max) of \code{z}.}
}
\value{
A numeric vector of length \code{n_t}. This vector has two attributes
\code{"start_regime"} and \code{"start_hyst"} corresponding to the values you provided.
These attributes are used by \code{\link[=hystar_sim]{hystar_sim()}}.
}
\description{
This is a function you can use to simulate time series data
for a threshold variable of the HysTAR model. The time series is a (co)sine
wave, such that thresholds are crossed in a predictable way.
This function is designed to be used in combination with \code{hystar_sim()}.
}
\details{
The first value of \code{y} that can be predicted in the HysTAR model is
at time point \eqn{\max\{d, p\} + 1}, where \eqn{p = \max\{p_0, p_1\}}.
This is because we need to observe \eqn{y_{t - p}} and \eqn{z_{t - d}}.
So the first observed value of \code{z} that determines a regime
is at time point \eqn{\max\{d, p\} + 1 - d}.
To make sure that this time point corresponds to the start that you request,
\code{z_sim()} starts with 10 extra time points. In this way, \code{\link{hystar_sim}} can
select the appropriate time points, based on \code{d} and \code{p0}, \code{p1}.
}
\section{The HysTAR model}{
The HysTAR model is defined as:

\eqn{ y_t = \begin{cases} \phi_{00} + \phi_{01} y_{t-1} + \cdots +
  \phi_{0 p_0} y_{t-p_0} + \sigma_{0} \epsilon_{t} \quad \mathrm{if}~R_{t} = 0 \\
  \phi_{10} + \phi_{11} y_{t-1} + \cdots + \phi_{1 p_1} y_{t-p_1} + \sigma_{1} \epsilon_{t}
  \quad \mathrm{if}~R_{t} = 1, \\ \end{cases} }

with \eqn{ R_t = \begin{cases} 0 \quad \quad \mathrm{if} \, z_{t-d} \in (-\infty, r_{0}] \\
  R_{t-1} \quad \mathrm{if} \, z_{t-d} \in (r_0, r_1] \\ 1 \quad \quad \mathrm{if} \, z_{t-d}
  \in (r_1, \infty), \\ \end{cases} }

where \eqn{p_j} denotes the order of regime \eqn{j \in \{0,1\}} with
coefficients \eqn{\phi_{j0}, \dots, \phi_{j p_j \in (-1, 1)}},
\eqn{\sigma_{j}} is the standard deviation of the residuals, and \eqn{d \in
  \{0, 1, 2, \dots\}} is a delay parameter. The parameters of primary interest are
the thresholds \eqn{r_0 \le r_1}. We let \eqn{t = 0, 1, 2, ..., T}, where \eqn{T}
is the number of observations.
}

\examples{
z <- z_sim(n_t = 200, n_switches = 5, start_regime = 1)
sim <- hystar_sim(z = z, r = c(-.5, .5), d = 2, phi_R0 = c(0, .6), phi_R1 = 1)
plot(sim)
fit <- hystar_fit(sim$data)
summary(fit)
}
