% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{all_multinom}
\alias{all_multinom}
\title{Get every possible non-negative tuple with of a given sum.}
\usage{
all_multinom(n, k)
}
\arguments{
\item{n}{Number of indistinguishable balls.}

\item{k}{Number of distinguishable bins.}
}
\value{
A matrix, rows index different possible multinomial counts,
the columns index the bins.
}
\description{
The total number of rows is \code{choose(n = k + n - 1, k = k - 1)}.
This function uses recursion, so is not the most efficient.
}
\examples{
n <- 5
k <- 3
all_multinom(n = n, k = k)
choose(n = n + k - 1, k = k - 1)

}
\author{
David Gerard
}
