% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{escape_contents}
\alias{escape_contents}
\alias{escape_contents<-}
\alias{set_escape_contents}
\alias{map_escape_contents}
\title{Escape or unescape text in cells}
\usage{
escape_contents(ht)

escape_contents(ht) <- value

set_escape_contents(ht, row, col, value)

map_escape_contents(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix. Set to \code{NA} to reset to the default, which is \code{TRUE}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}
}
\description{
Setting \code{escape_contents} to \code{FALSE} allows you to include raw HTML or
TeX code in your cells.
}
\details{
If \code{\link[=markdown]{markdown()}} is \code{TRUE} for a cell, the \code{escape_contents} property
will be ignored.
}
\examples{
ht <- huxtable(
  Text   = "x squared",
  Maths  = "$x^2$"
)
ht <- set_escape_contents(ht, FALSE)
\dontrun{
quick_pdf(ht)
}

}
\seealso{
\code{\link[=sanitize]{sanitize()}} for escaping text manually.
}
