% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doApiQuery.R
\name{convert_list_to_tibble}
\alias{convert_list_to_tibble}
\title{Convert list provided by the APIs into a tibble}
\usage{
convert_list_to_tibble(l)
}
\arguments{
\item{l}{a \link{list} provided by the API (See \link{doApiQuery})}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
Convert list provided by the APIs into a tibble
}
\details{
This function is used internally by all the retrieving data functions for
converting data after the call to \link{doApiQuery}.
}
\examples{
# To get the available APIs in the package
list_apis()

# To get the available endpoints in an API
list_endpoints("prelevements")

# To get available parameters in endpoint "chroniques" of the API "prelevements"
list_params(api = "prelevements", endpoint = "chroniques")

# To query the endpoint "chroniques" of the API "prelevements"
# on all devices in the commune of Romilly-sur-Seine in 2018
\dontrun{
resp <- doApiQuery(api = "prelevements",
                   endpoint = "chroniques",
                   code_commune_insee = "10323",
                   annee = "2018")
convert_list_to_tibble(resp)
}
}
