% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-marray-arithmetic.r,
%   R/method-mvector-arithmetic.r
\name{Arithmetic}
\alias{Arithmetic}
\alias{+,mmatrixOrMarray,mvectorOrNumeric-method}
\alias{+,mvectorOrNumeric,mmatrixOrMarray-method}
\alias{+,mmatrixOrMarray,array-method}
\alias{+,array,mmatrixOrMarray-method}
\alias{+,mmatrixOrMarray,mmatrixOrMarray-method}
\alias{-,mmatrixOrMarray,mvectorOrNumeric-method}
\alias{-,mvectorOrNumeric,mmatrix-method}
\alias{-,mvectorOrNumeric,marray-method}
\alias{-,mmatrixOrMarray,array-method}
\alias{-,matrix,mmatrix-method}
\alias{-,array,marray-method}
\alias{-,mmatrixOrMarray,mmatrixOrMarray-method}
\alias{-,mmatrixOrMarray,missing-method}
\alias{*,mmatrixOrMarray,mvectorOrNumeric-method}
\alias{*,mvectorOrNumeric,mmatrixOrMarray-method}
\alias{*,mmatrixOrMarray,array-method}
\alias{*,array,mmatrixOrMarray-method}
\alias{*,mmatrixOrMarray,mmatrixOrMarray-method}
\alias{/,mmatrixOrMarray,mvectorOrNumeric-method}
\alias{/,mvectorOrNumeric,mmatrix-method}
\alias{/,mvectorOrNumeric,marray-method}
\alias{/,mmatrixOrMarray,array-method}
\alias{/,matrix,mmatrix-method}
\alias{/,array,marray-method}
\alias{/,mmatrixOrMarray,mmatrixOrMarray-method}
\alias{+,mvector,mvectorOrNumeric-method}
\alias{+,numeric,mvector-method}
\alias{-,mvector,mvectorOrNumeric-method}
\alias{-,numeric,mvector-method}
\alias{-,mvector,missing-method}
\alias{*,mvector,mvectorOrNumeric-method}
\alias{*,numeric,mvector-method}
\alias{/,mvector,mvectorOrNumeric-method}
\alias{/,numeric,mvector-method}
\title{Arithmetic Operators}
\usage{
\S4method{+}{mmatrixOrMarray,mvectorOrNumeric}(e1, e2)

\S4method{+}{mvectorOrNumeric,mmatrixOrMarray}(e1, e2)

\S4method{+}{mmatrixOrMarray,array}(e1, e2)

\S4method{+}{array,mmatrixOrMarray}(e1, e2)

\S4method{+}{mmatrixOrMarray,mmatrixOrMarray}(e1, e2)

\S4method{-}{mmatrixOrMarray,mvectorOrNumeric}(e1, e2)

\S4method{-}{mvectorOrNumeric,mmatrix}(e1, e2)

\S4method{-}{mvectorOrNumeric,marray}(e1, e2)

\S4method{-}{mmatrixOrMarray,array}(e1, e2)

\S4method{-}{matrix,mmatrix}(e1, e2)

\S4method{-}{array,marray}(e1, e2)

\S4method{-}{mmatrixOrMarray,mmatrixOrMarray}(e1, e2)

\S4method{-}{mmatrixOrMarray,missing}(e1, e2)

\S4method{*}{mmatrixOrMarray,mvectorOrNumeric}(e1, e2)

\S4method{*}{mvectorOrNumeric,mmatrixOrMarray}(e1, e2)

\S4method{*}{mmatrixOrMarray,array}(e1, e2)

\S4method{*}{array,mmatrixOrMarray}(e1, e2)

\S4method{*}{mmatrixOrMarray,mmatrixOrMarray}(e1, e2)

\S4method{/}{mmatrixOrMarray,mvectorOrNumeric}(e1, e2)

\S4method{/}{mvectorOrNumeric,mmatrix}(e1, e2)

\S4method{/}{mvectorOrNumeric,marray}(e1, e2)

\S4method{/}{mmatrixOrMarray,array}(e1, e2)

\S4method{/}{matrix,mmatrix}(e1, e2)

\S4method{/}{array,marray}(e1, e2)

\S4method{/}{mmatrixOrMarray,mmatrixOrMarray}(e1, e2)

\S4method{+}{mvector,mvectorOrNumeric}(e1, e2)

\S4method{+}{numeric,mvector}(e1, e2)

\S4method{-}{mvector,mvectorOrNumeric}(e1, e2)

\S4method{-}{numeric,mvector}(e1, e2)

\S4method{-}{mvector,missing}(e1, e2)

\S4method{*}{mvector,mvectorOrNumeric}(e1, e2)

\S4method{*}{numeric,mvector}(e1, e2)

\S4method{/}{mvector,mvectorOrNumeric}(e1, e2)

\S4method{/}{numeric,mvector}(e1, e2)
}
\arguments{
\item{e1}{first operand}

\item{e2}{second operand}
}
\value{
an object of class mvector, mmatrix or marray depending on 
the operand classes.
}
\description{
Arithmetic operators for memory mapped objects
}
\details{
The usual operations are performed. Values are recycled if necessary.
There's no type promotion: if one of the operands is a R object and the other
is a memory-mapped object, the result will be a memory mapped object with same
data type as the operand. If both operand are memory mapped objects with different
data types, the result will be a memory mapped object with the same data type than
the left operand.
}
\examples{
x <- as.mvector(2**(1:4))
y <- 2*x
x <- x/2
x + c(1,2) / y
}
\seealso{
\link{inplace}
}
