\name{speed_boot_LR_extra}
\alias{speed_boot_LR_extra}
\docType{data}
\title{
  speed boot LR
}
\description{
  Example of a parametric bootstrap for model selection
}
\usage{data("speed_boot_LR")}
\format{
  A \code{boot} object
}
\details{
  The bootstrap sample was generated by the following code:
    
    \preformatted{require(depmixS4)
      require(hmmr)
      require(boot)
      
      data(speed1)
      set.seed(5)
      spmix2 <- mix(RT~1, data=speed1, nstates=2)
      fspmix2 <- fit(spmix2,verbose=FALSE)
      
      set.seed(5)
      fspmix3 <- fit(mix(RT~1,data=speed1,nstates=3))
      
      speed.fun.LR <- function(model) {
        ok <- FALSE
        while(!ok) {
          bootdat <- data.frame(RT = simulate(model)@response[[1]][[1]]@y)
          fboot2 <- try({
            mod <- mix(RT~1,data=bootdat,nstates=2)
            mod <- setpars(mod,getpars(fspmix2))
            fit(mod,emcontrol=em.control(random.start=FALSE),verbose=FALSE)
          },TRUE)
          fboot3 <- try({
            mod <- mix(RT~1,data=bootdat,nstates=3)
            mod <- setpars(mod,getpars(fspmix3))
            fit(mod,emcontrol=em.control(random.start=FALSE),verbose=FALSE)
          },TRUE)
          if(!inherits(fboot2,"try-error") & !inherits(fboot3,"try-error")) ok <- TRUE
        }
        if(ok & logLik(fboot3) < logLik(fboot2)) ok <- FALSE
        while(!ok) {
          cat("trying different starting-values")
          fboot3 <- try({
            mod <- mix(RT~1,data=bootdat,nstates=3)
            mod <- setpars(mod,getpars(fspmix3))
            fit(mod,verbose=FALSE)
          },TRUE)
          if(!inherits(fboot3,"try-error") & logLik(fboot3) > logLik(fboot2)) ok <- TRUE
        }
        llratio(fboot3,fboot2)@value
      }
      set.seed(5)
      speed_boot_LR <- boot(fspmix2,speed.fun.LR,R=1000,sim="parametric")
      
      set.seed(7)
      speed_boot_LR_extra <- boot(fspmix2,speed.fun.LR,R=4000,
          sim="parametric",parallel="multicore",ncpus=6)
      (1+sum(c(speed_boot_LR$t,speed_boot_LR_extra$t) > 
          llratio(fspmix3,fspmix2)@value))/
          ((speed_boot_LR$R+speed_boot_LR_extra$R)+1)
    }
}
\examples{
  data(speed_boot_LR)
}
\keyword{datasets}
