% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{example_model}
\alias{example_model}
\title{Generate Example Optimization Models}
\usage{
example_model(op_type = c("LP", "MILP", "QP"))
}
\arguments{
\item{op_type}{Character string specifying the type of optimization model.
Must be one of "LP", "MILP", or "QP".}
}
\value{
A HiGHS model object configured according to the specified type:
  - LP: Maximization problem with 3 variables and 3 constraints
  - MILP: Maximization problem with mixed integer and continuous variables
  - QP: Problem with quadratic objective function
}
\description{
Creates example optimization models for different problem types:
- Linear Programming (LP)
- Mixed Integer Linear Programming (MILP)
- Quadratic Programming (QP)
}
\examples{
model <- example_model("LP")
model <- example_model("MILP")
model <- example_model("QP")

}
