% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_surv_list.R
\name{params_surv_list}
\alias{params_surv_list}
\title{Parameters of a list of survival models}
\usage{
params_surv_list(...)
}
\arguments{
\item{...}{Objects of class \code{\link{params_surv}}, which can be named.}
}
\value{
An object of class \code{params_surv_list}, which is a list containing \code{\link{params_surv}}
objects.
}
\description{
Create a list containing the parameters of multiple fitted parametric survival models.
}
\examples{
n <- 5
params <- params_surv_list(
  # Model for progression free survival
  pfs = params_surv(
    coefs = list(
      rate = data.frame(intercept = rnorm(n, log(.5), .5),
                        new_strategy = rnorm(n, log(.8), .1))
   ),
    dist = "exp"
  ),
 
  # Model for overall survival
  os = params_surv(
    coefs = list(
      rate = data.frame(intercept = rnorm(n, log(.3) , .5))
    ),
    dist = "exp"
  )
)
summary(params)
params
}
\seealso{
\code{\link[=create_params]{create_params()}}
}
