% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-general.R
\name{ce}
\alias{ce}
\title{A cost-effectiveness object}
\format{
A list containing two elements:
\describe{
\item{\code{costs}}{Total (discounted) costs by category.}
\item{\code{qalys}}{(Discounted) quality-adjusted life-years.}
}
}
\description{
An object that summarizes simulated measures of clinical effectiveness and
costs from a simulation model for use in a cost-effectiveness analysis.
}
\section{Costs}{

The \code{costs} \code{data.table} contains the following columns:
\describe{
\item{category}{The cost category.}
\item{dr}{The discount rate.}
\item{sample}{A randomly sampled parameter set from the probabilistic sensitivity analysis (PSA)}
\item{strategy_id}{The treatment strategy ID.}
\item{grp_id}{An optional column denoting a subgroup. If not included, it is
assumed that a single subgroup is being analyzed.}
\item{costs}{Costs.}
}
}

\section{Quality-adjusted life-years}{

The \code{qalys} \code{data.table} contains the following columns:
\describe{
\item{dr}{The discount rate.}
\item{sample}{A randomly sampled parameter set from the probabilistic sensitivity analysis (PSA)}
\item{strategy_id}{The treatment strategy ID.}
\item{grp_id}{An optional column denoting a subgroup. If not included, it is
assumed that a single subgroup is being analyzed.}
\item{qalys}{Quality-adjusted life-years}
}
}

