% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_whole_fast.R
\name{make_whole_fast}
\alias{make_whole_fast}
\title{Constructs a continuous, uninterrupted time series of temperatures (faster).}
\usage{
make_whole_fast(data)
}
\arguments{
\item{data}{A data frame with columns for date (\code{ts_x}) and
temperature (\code{ts_y}) data. Ordered daily data are expected, and
although missing values (NA) can be accommodated, the function is only
recommended when NAs occur infrequently, preferably at no more than three
consecutive days.}
}
\value{
The function will return a data frame with three columns. The column
headed \code{doy} (day-of-year) is the Julian day running from 1 to 366, but
modified so that the day-of-year series for non-leap-years runs 1...59 and
then 61...366. For leap years the 60th day is February 29. The \code{ts_x}
column is a series of dates of class \code{Date}, while \code{y} is the
measured variable. This time series will be uninterrupted and continuous daily
values between the first and last dates of the input data.
}
\description{
Takes a series of dates and temperatures, and if irregular (but ordered), inserts
missing dates and fills corresponding temperatures with NAs.
}
\details{
\enumerate{
\item This function reads in daily data with the time vector specified as
 \code{Date} (e.g. "1982-01-01").

\item It is up to the user to calculate daily data from sub-daily measurements.
Leap years are automatically accommodated by this function.

\item This function can handle some missing days, but this is not a
licence to actually use these data for the detection of anomalous thermal
events. Hobday et al. (2016) recommend gaps of no more than 3 days, which
may be adjusted by setting the \code{maxPadLength} argument of the
\code{\link{ts2clm}} function. The longer and more frequent the gaps become
the lower the fidelity of the annual climatology and threshold that can be
calculated, which will not only have repercussions for the accuracy at which
the event metrics can be determined, but also for the number of events that
can be detected.

The day-of-year (doy) vector is created in \code{make_whole_fast} and
inserts rows in cases when the original data set has missing rows for some dates.
Should the user be concerned about the potential for repeated measurements
or worry that the time series is unordered, we suggest that the necessary
checks and fixes are implemented prior to feeding the time series to \code{ts2clim}
via \code{make_whole_fast}. When using this fast algorithm,
we assume that the user has done all the necessary work to ensure that the time
vector is ordered and without repeated measurements beforehand.
}
}
\author{
Smit, A. J., Villeneuve, A., Schlegel, R. W.
}
\keyword{internal}
