% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5wrapper.R
\name{list-groups-datasets}
\alias{list-groups-datasets}
\alias{list.groups}
\alias{list.datasets}
\alias{list.objects}
\title{List Groups and Datasets in object}
\usage{
list.groups(object, path = "/", full.names = FALSE, recursive = TRUE,
  ...)

list.datasets(object, path = "/", full.names = FALSE,
  recursive = TRUE, ...)

list.objects(object, obj_type = c("H5I_GROUP", "H5I_DATASET",
  "H5I_DATATYPE"), path = "/", full.names = FALSE, recursive = TRUE,
  ...)
}
\arguments{
\item{object}{\code{CommonFG}; Object implementing the CommonFG Interface (e.g. \code{\link{H5File}}, \code{\link{H5Group}}).}

\item{path}{character; Path named to be used for iteration.}

\item{full.names}{character; Specify if absolute DataSet path names should be returned.}

\item{recursive}{logical; Specify if object should be traversed recursively.}

\item{...}{Additional Parameters passed to \code{$ls()}}

\item{obj_type}{character; Object type to be returned.}
}
\value{
\code{\link{character}}
}
\description{
List all Group (\code{\link{H5Group}}) and Dataset (\code{\link{H5D}}) 
names in the current object. This function is part of the \strong{h5} wrapper classes and
uses \code{$ls()} to retrieve group names.
}
