/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Cmodule.h" 

#include "H5private.h"   
#include "H5ACprivate.h" 
#include "H5Cpkg.h"      
#include "H5Eprivate.h"  
#include "H5Fprivate.h"  

static herr_t H5C__epoch_marker_get_initial_load_size(void *udata_ptr, size_t *image_len_ptr);
static herr_t H5C__epoch_marker_get_final_load_size(const void *image_ptr, size_t image_len_ptr,
                                                    void *udata_ptr, size_t *actual_len);
static htri_t H5C__epoch_marker_verify_chksum(const void *image_ptr, size_t len, void *udata_ptr);
static void  *H5C__epoch_marker_deserialize(const void *image_ptr, size_t len, void *udata, bool *dirty_ptr);
static herr_t H5C__epoch_marker_image_len(const void *thing, size_t *image_len_ptr);
static herr_t H5C__epoch_marker_pre_serialize(H5F_t *f, void *thing, haddr_t addr, size_t len,
                                              haddr_t *new_addr_ptr, size_t *new_len_ptr,
                                              unsigned *flags_ptr);
static herr_t H5C__epoch_marker_serialize(const H5F_t *f, void *image_ptr, size_t len, void *thing);
static herr_t H5C__epoch_marker_notify(H5C_notify_action_t action, void *thing);
static herr_t H5C__epoch_marker_free_icr(void *thing);
static herr_t H5C__epoch_marker_fsf_size(const void H5_ATTR_UNUSED *thing,
                                         hsize_t H5_ATTR_UNUSED    *fsf_size_ptr);

const H5AC_class_t H5AC_EPOCH_MARKER[1] = {
    { H5AC_EPOCH_MARKER_ID,
      "epoch marker",
      H5FD_MEM_DEFAULT, 
      H5AC__CLASS_NO_FLAGS_SET,
      H5C__epoch_marker_get_initial_load_size,
      H5C__epoch_marker_get_final_load_size,
      H5C__epoch_marker_verify_chksum,
      H5C__epoch_marker_deserialize,
      H5C__epoch_marker_image_len,
      H5C__epoch_marker_pre_serialize,
      H5C__epoch_marker_serialize,
      H5C__epoch_marker_notify,
      H5C__epoch_marker_free_icr,
      H5C__epoch_marker_fsf_size}};

static herr_t
H5C__epoch_marker_get_initial_load_size(void H5_ATTR_UNUSED *udata_ptr, size_t H5_ATTR_UNUSED *image_len_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_get_final_load_size(const void H5_ATTR_UNUSED *image_ptr, size_t H5_ATTR_UNUSED image_len,
                                      void H5_ATTR_UNUSED *udata_ptr, size_t H5_ATTR_UNUSED *actual_len)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static htri_t
H5C__epoch_marker_verify_chksum(const void H5_ATTR_UNUSED *image_ptr, size_t H5_ATTR_UNUSED len,
                                void H5_ATTR_UNUSED *udata_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(false)
} 

static void *
H5C__epoch_marker_deserialize(const void H5_ATTR_UNUSED *image_ptr, size_t H5_ATTR_UNUSED len,
                              void H5_ATTR_UNUSED *udata, bool H5_ATTR_UNUSED *dirty_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(NULL)
} 

static herr_t
H5C__epoch_marker_image_len(const void H5_ATTR_UNUSED *thing, size_t H5_ATTR_UNUSED *image_len_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_pre_serialize(H5F_t H5_ATTR_UNUSED *f, void H5_ATTR_UNUSED *thing,
                                haddr_t H5_ATTR_UNUSED addr, size_t H5_ATTR_UNUSED len,
                                haddr_t H5_ATTR_UNUSED *new_addr_ptr, size_t H5_ATTR_UNUSED *new_len_ptr,
                                unsigned H5_ATTR_UNUSED *flags_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_serialize(const H5F_t H5_ATTR_UNUSED *f, void H5_ATTR_UNUSED *image_ptr,
                            size_t H5_ATTR_UNUSED len, void H5_ATTR_UNUSED *thing)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_notify(H5C_notify_action_t H5_ATTR_UNUSED action, void H5_ATTR_UNUSED *thing)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_free_icr(void H5_ATTR_UNUSED *thing)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 

static herr_t
H5C__epoch_marker_fsf_size(const void H5_ATTR_UNUSED *thing, hsize_t H5_ATTR_UNUSED *fsf_size_ptr)
{
    FUNC_ENTER_PACKAGE_NOERR 

        HERROR(H5E_CACHE, H5E_SYSTEM, "called unreachable fcn.");

    FUNC_LEAVE_NOAPI(FAIL)
} 
