% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diversities.R
\name{diversities_table}
\alias{diversities_table}
\title{Custom Print for hagis Diversities Tables}
\usage{
diversities_table(x, ...)
}
\arguments{
\item{x}{a \code{hagis.diversities} object generated by \code{\link[=calculate_diversities]{calculate_diversities()}}}

\item{...}{other arguments passed to \code{\link[pander:panderOptions]{pander::panderOptions()}}}
}
\value{
A \code{\link[pander:pandoc.table.return]{pander::pandoc.table()}} object of diversities
}
\description{
Print the frequency table of diversities from a \code{hagis.diversities} object
The resulting object is a \CRANpkg{pander} table (a text object for Markdown)
for ease of use in reporting and viewing in the console.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Using the built-in data set, P_sojae_survey
data(P_sojae_survey)

P_sojae_survey

# calculate susceptibilities with a 60 \% cutoff value
diversities <- calculate_diversities(
  x = P_sojae_survey,
  cutoff = 60,
  control = "susceptible",
  sample = "Isolate",
  gene = "Rps",
  perc_susc = "perc.susc"
)

# print the diversities table
diversities_table(diversities)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=calculate_diversities]{calculate_diversities()}}, \code{\link[=individual_pathotypes]{individual_pathotypes()}}
}
