% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{cells_to_multipolygon}
\alias{cells_to_multipolygon}
\title{Get geometry for a set of H3 cells}
\usage{
cells_to_multipolygon(h3_addresses = NULL, simple = TRUE)
}
\arguments{
\item{h3_addresses}{Character vector or list of 15-character cell indices
generated by H3.}

\item{simple}{Logical; whether to return an \code{sfc_MULTIPOLYGON} or an
\code{sf} object including the input cells.}
}
\value{
By default, object of type \code{sfc_MULTIPOLYGON} of length 1.
}
\description{
This function returns geometry associated with a set of H3 cells, as a
single \code{sfc_MULTIPOLYGON}.
}
\note{
The geometry returned by this function will not be valid where the
  addresses supplied overlap at the same resolution. The main use case for
  this function appears to be visualising the outputs of
  \code{\link[h3jsr:polygon_to_cells]{polygon_to_cells}} and
  \code{\link[h3jsr:compact]{compact}}.
}
\examples{
\dontrun{
# Give me the outline of the cells around Brisbane Town Hall at
# resolution 10 (not run as slow-ish)
bth <- sf::st_sfc(sf::st_point(c(153.023503, -27.468920)), crs = 4326)
bth_10 <- point_to_h3(bth, res = 10)
bth_patch <- get_disk(h3_address = bth_10, ring_size = 2)
bth_patch_sf <- cells_to_multipolygon(bth_patch)
}
}
