% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_valid_stop_times}
\alias{filter_valid_stop_times}
\title{Filter GTFS data using valid stop times}
\usage{
filter_valid_stop_times(gtfs_data)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data read using gtfs2gps::read_gtfs(). It removes stop_times
with NA values in arrival_time, departure_time, and arrival_time_hms. It also filters
stops and routes accordingly.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

subset <- filter_valid_stop_times(poa)
}
