% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ef_brazil_cetesb_db}
\alias{ef_brazil_cetesb_db}
\title{Emission factors from Environment Company of Sao Paulo, Brazil (CETESB)}
\format{
A data.table:
\describe{
\item{pollutant}{ character; Pollutants: "CH4", "CO2", "PM10", "N2O", "KML",
"FC" (Fuel Consumption), "gD/KWH", "gCO2/KWH", "CO", "HC" (Total Hydrocarbon),
"NMHC" (Non-Methane Hydrocarbon), "NOx", "NO2", "NO", "RCHO", "ETOH",
"FS"(Fuel Sales) and "NH3"}
\item{veh_type}{character; Vehicle categories by fuel:"BUS_URBAN_D", "BUS_MICRO_D",
"BUS_COACH_D" and "BUS_ARTIC_D".}
\item{model_year}{numeric; Filter the emission factor to start from a specific
base year. }
\item{as_list}{logical; Returns emission factors as a list, instead of data.table
format.}
}
}
\usage{
ef_brazil_cetesb_db
}
\description{
units 'g/km'; Emission factors for buses based on estimates from the
Environment Company of Sao Paulo, Brazil (CETESB) 2017,
and obtained from \href{https://github.com/atmoschem/vein}{vein package}.
The R script used to organize the CETESB database can be found in the repository
<\url{https://github.com/ipeaGIT/gtfs2emis/blob/master/data-raw/ef_brazil_cetesb_db.R}>.
}
\seealso{
Other emission factor data: 
\code{\link{ef_europe_emep_db}},
\code{\link{ef_usa_emfac_db}},
\code{\link{ef_usa_moves_db}}
}
\concept{emission factor data}
\keyword{datasets}
