% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{ldPrimaryBoundary}
\alias{ldPrimaryBoundary}
\title{Calculate Primary Boundaries, the Error Spending Approach}
\usage{
ldPrimaryBoundary(tVec, alpha, type = 1, initIntvl = c(0.8, 8))
}
\arguments{
\item{tVec}{a vector of information, gammaVec = sqrt(tVec).}

\item{alpha}{significance level}

\item{type}{type of sequential procedure. OBF is 1, POC is 2.}

\item{initIntvl}{paramter for function uniroot (two numbers)}
}
\value{
a vector of primary boundaries.
}
\description{
Primary boundaries calculation of Lan-DeMets OBF and POC.
}
\references{
Lan, K. K. G., and Demets, D. L. (1983). Discrete sequential boundaries for clinical trials. \emph{Biometrika} \bold{70}, 659-663.

Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2018). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, 74(1), 40-48.

Gou, J. (2023). Trigger strategy in repeated tests on multiple hypotheses. \emph{Statistics in Biopharmaceutical Research}, 15(1), 133–140.
}
\seealso{
\code{primaryBoundary}
}
\author{
Jiangtao Gou
}
